document.addEventListener('DOMContentLoaded', () => {
    const controls = {
        tintColor: document.getElementById('tint-color-picker'),
        windowOpacity: document.getElementById('opacity-slider'),
        activeTabColor: document.getElementById('active-tab-color-picker'),
        userBubbleColor: document.getElementById('user-bubble-color-picker'),
        aiBubbleColor: document.getElementById('ai-bubble-color-picker'),
        textModel: document.getElementById('text-model-select'),
        imageModel: document.getElementById('image-model-select'),
    };
    
    let currentSettings = {};

    function updateUI(settings) {
        currentSettings = settings;
        document.documentElement.style.setProperty('--active-tab-color', settings.activeTabColor);
        
        controls.tintColor.value = settings.tintColor;
        controls.windowOpacity.value = settings.windowOpacity;
        controls.activeTabColor.value = settings.activeTabColor;
        controls.userBubbleColor.value = settings.userBubbleColor;
        controls.aiBubbleColor.value = settings.aiBubbleColor;
        controls.textModel.value = settings.textModel;
        controls.imageModel.value = settings.imageModel;
    }

    function renderIcons() {
        document.getElementById('close-settings-btn').innerHTML = icons.x;
        document.querySelector('[data-tab="appearance"]').innerHTML = `${icons.palette} Appearance`;
        document.querySelector('[data-tab="ai"]').innerHTML = `${icons.cpu} AI Models`;
    }

    window.electronAPI.invoke('get-store-data').then(data => {
        updateUI(data.settings);
        renderIcons();
    });

    function setSetting(key, value) {
        currentSettings[key] = value;
        window.electronAPI.send('set-store-data', { settings: currentSettings });
    }
    
    window.electronAPI.on('store-updated', (data) => updateUI(data.settings));

    const tabButtons = document.querySelectorAll('.settings-tab-btn');
    const tabContents = document.querySelectorAll('.settings-tab-content');
    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            tabButtons.forEach(btn => btn.classList.remove('active'));
            button.classList.add('active');
            tabContents.forEach(content => content.classList.toggle('active', content.id === `tab-${button.dataset.tab}`));
        });
    });

    controls.tintColor.addEventListener('input', (e) => setSetting('tintColor', e.target.value));
    controls.windowOpacity.addEventListener('input', (e) => setSetting('windowOpacity', parseFloat(e.target.value)));
    controls.activeTabColor.addEventListener('input', (e) => setSetting('activeTabColor', e.target.value));
    controls.userBubbleColor.addEventListener('input', (e) => setSetting('userBubbleColor', e.target.value));
    controls.aiBubbleColor.addEventListener('input', (e) => setSetting('aiBubbleColor', e.target.value));
    controls.textModel.addEventListener('change', (e) => setSetting('textModel', e.target.value));
    controls.imageModel.addEventListener('change', (e) => setSetting('imageModel', e.target.value));
    
    document.getElementById('close-settings-btn').addEventListener('click', () => window.electronAPI.send('close-settings-window'));
    
    document.getElementById('pollinations-link').addEventListener('click', (e) => {
        e.preventDefault();
        window.electronAPI.send('open-external-link', 'https://pollinations.ai');
    });
});